//
//  MCDelegationManager.h
//  MCFoundation
//
//  Created by Eric Hochmeister on 30/08/05.
//  Copyright 2005 __MyCompanyName__. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "MCDelegateUser.h"
#import "MCDelegateObject.h"
#import "MCDelegateEntry.h"

@interface MCDelegationManager : NSObject {

}

/*!
    @method     parseDelegationChain:
    @abstract   parses a delegation chain into an array of user ids
    @discussion (comprehensive description)
    @param      aChain - NSString in the form |userID1||userID2||userID3||userID4| etc.
    @result     NSArray - an array of userID's... ( userID1, userID2, userID3, userID4 )
*/
+ (NSArray*)parseDelegationChain:(NSString*)aChain;

/*!
    @method     buildDelegationChain:
    @abstract   builds a delegation chain from an array of user ids
    @discussion (comprehensive description)
    @param      userIDs - NSArray - an array of userIDs
    @result     NSString - a string of userIDs... which respects the same order as the array of userids
*/
+ (NSString*)buildDelegationChain:(NSArray*)userIDs;

/*!
    @method     addDelegateUser:forObject:
    @abstract   add a delegate user to the object
    @discussion (comprehensive description)
    @param      aUser - the user who the object is being delegated to and will become the owner
    @param      anObject - the object which is being delegated
*/
//- (void)addDelegateUser:(id)aUser forObject:(id)anObject;

+ (NSString*)addUser:(id <MCDelegateUser>)aUser toDelegateChain:(NSString*)aChain;

/*!
    @method     user:isaDelegateOfObject:
    @abstract   checks if the user is a delegate/owner of the object... does the user exist in the delegation chain
    @discussion (comprehensive description)
    @param      aUser - the user who we're checking to see if they exist in the delegation chain
    @param      anObject - the object in question
    @result     YES if the user id appears in the delegation chain, NO otherwise
*/
//+ (BOOL)user:(id)aUser isaDelegateOfObject:(id)anObject;
+ (BOOL)user:(id <MCDelegateUser>)aUser isaDelegateOfObject:(id <MCDelegateObject>)anObject;

/*!
    @method     user:requiresNotificationForObject:
    @abstract   checks if the user requires notifications for this object
    @discussion (comprehensive description)
    @param      anObject - the object in question
    @result     YES, if the user requires notification for this object, NO otherwise
*/
//- (BOOL)user:(id)aUser requiresNotificationForObject:(id)anObject;

/*!
    @method     user:delegateObject:toUser:notifyUser:
    @abstract   a user delegates an Object to another user and specifies if they want to be notified of anything
    @discussion (comprehensive description)
    @param      curUser - the user who the object is currently delegated to or who owns the object
    @param      anObject - object in question
    @param      delegateUser - the user the object is being delegated to
    @param      aNote - the note specifying why the object is being delegated
    @param      notify - should curUser be notified of anything that happens to anObject?
*/
//+ (void)user:(id)curUser delegateObject:(id)anObject toUser:(id)delegateUser withNote:(NSString*)aNote notifyUser:(BOOL)notify;
+ (void)user:(id <MCDelegateUser>)curUser 
delegateObject:(id <MCDelegateObject>)anObject 
      toUser:(id <MCDelegateUser>)delegateUser
    withNote:(NSString*)aNote
  notifyUser:(BOOL)notify;

+ (void)removeAllDelegatesFromObject:(id <MCDelegateObject>)anObject setOwner:(id <MCDelegateUser>)aUser;
+ (void)removeLastDelegateFromObject:(id <MCDelegateObject>)anObject;

+ (NSDictionary*)delegateDictForUser:(id <MCDelegateUser>)curUser
                      delegateObject:(id <MCDelegateObject>)anObject
                              toUser:(id <MCDelegateUser>)delegateUser
                            withNote:(NSString*)aNote
                          notifyUser:(BOOL)notify;

+ (void)delegateUsingDelegateDict:(NSDictionary*)aDict;

+ (void)notifyDelegatesOfChanges: (NSDictionary*)changes toObject: (id)object byUser: (id <MCDelegateUser>)changingUser;

+ (void)notifyForDeletionOfObject:(id)object byUser:(id <MCDelegateUser>)user;

@end
